"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper";
import { LoadingDialog } from "@/components/loading.dialog";
import { useGetAgencies } from "@/hooks/use-get-agencies";
import { useGetStatewideServices } from "@/hooks/use-get-statewide-services";
import { WorkflowDialog } from "./workflow.dialog";

export function WorkflowDialogClient() {
  const res = useGetStatewideServices();
  const { data: agencies } = useGetAgencies();
  if (!agencies) {
    return (
      <LoadingDialog />
    )
  }

  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: <LoadingDialog />,
      }}
      content={(data) => (
        <WorkflowDialog data={data} agencies={agencies ?? []} />
      )}
    />
  )
}

